IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_CORRIGE_VLR_OUTRAS_EST_NF_ENT]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_CORRIGE_VLR_OUTRAS_EST_NF_ENT]
GO
GO
GO
--exec  P_CORRIGE_VLR_OUTRAS_EST_NF_ENT 0,'2014-03-01','2014-05-20',1
CREATE PROCEDURE [dbo].[P_CORRIGE_VLR_OUTRAS_EST_NF_ENT] (@FILIAL INT=0, @DT_INI DATETIME, @DT_FIM DATETIME, @REFAZER_VALOR INT=0,@CONSULTA INT =0 )
AS

	IF  OBJECT_ID('TEMPDB.DBO.#TMP_RATEIO') IS NOT NULL
	BEGIN
		 DROP TABLE #TMP_RATEIO
	END
  
	SELECT 
		ROW_NUMBER() OVER (ORDER BY A.CD_FILIAL, A.CD_NF, B.DS_PROD) SEQ,
		A.CD_FILIAL,
		A.CD_NF,
		CD_PROD, 
		ROUND(CONVERT(MONEY, (((B.VLR_IT * B.QT_IT)- b.VLR_DESC)/ A.VLR_NF) * A.VLR_OUTROS),2) NOVO_RATEIO , 
		ROUND(B.VLR_OUTRAS_DESPESAS,2) VLR_OUTRAS_DESPESAS,
		A.VLR_OUTROS,
		CONVERT(MONEY, 0.0000 ) SOMA_RATEIO,
		CONVERT(MONEY, 0.0000 ) DIFER
		INTO  #TMP_RATEIO
	FROM 
		EST_NF_ENT A
		INNER JOIN EST_NF_ENT_IT B ON
		A.CD_EMP = B.CD_EMP AND
		A.CD_NF		= B.CD_NF AND
		A.CD_FILIAL = B.CD_FILIAL
	WHERE 
		A.CD_EMP=1
		AND A.CD_FILIAL = CASE WHEN @FILIAL=0 THEN A.CD_FILIAL ELSE @FILIAL END
		AND A.DT_ENT BETWEEN @DT_INI AND @DT_FIM
		AND A.VLR_OUTROS > 0 
	ORDER BY A.CD_FILIAL, A.CD_NF, B.DS_PROD 
	
	IF @REFAZER_VALOR=0
	--Apaga os dados que estao ok
	begin
		DELETE 
		FROM a 
		from
			#TMP_RATEIO a
			inner join (select CD_FILIAL,
							CD_NF, sum (VLR_OUTRAS_DESPESAS) SOMA_OUTRAS
						from #TMP_RATEIO 
						GROUP BY CD_FILIAL,
							CD_NF) b on 
			a.CD_FILIAL = B.CD_FILIAL AND 
			a.CD_NF = B.CD_NF
		WHERE 
			B.SOMA_OUTRAS = A.VLR_OUTROS;
	end		
			  

	UPDATE A
	SET
		A.SOMA_RATEIO =  B.SOMA_RATEIO,
		A.DIFER =  VLR_OUTROS - B.SOMA_RATEIO
	FROM
	#TMP_RATEIO A
	INNER JOIN ( SELECT 
					CD_FILIAL,
					CD_NF,
					ROUND(SUM(NOVO_RATEIO),2) SOMA_RATEIO
				FROM 
					#TMP_RATEIO
					GROUP BY CD_FILIAL,
					CD_NF) B ON 
	A.CD_FILIAL = B.CD_FILIAL AND 
	A.CD_NF = B.CD_NF  
 
	
	DECLARE @CD_FILIAL INT , @CD_NF INT , @CD_PROD INT, @SEQ INT, @VLR MONEY
	

	DECLARE crateio CURSOR FAST_FORWARD FOR 
	SELECT 
		CD_FILIAL,
		CD_NF,
		CD_PROD,
		SEQ
	FROM 
		#TMP_RATEIO 
	WHERE 
		 DIFER <> 0
	ORDER BY SEQ DESC
		
		
	OPEN crateio
	FETCH NEXT FROM crateio INTO @CD_FILIAL , @CD_NF , @CD_PROD, @SEQ
	WHILE @@FETCH_STATUS=0
	begin
		
		SET @VLR = (SELECT DIFER
						FROM 
							#TMP_RATEIO
						WHERE
							CD_FILIAL =@CD_FILIAL
							AND CD_NF =@CD_NF
							AND CD_PROD = @CD_PROD
							AND SEQ = @SEQ)
			
		UPDATE #TMP_RATEIO
		SET	
			NOVO_RATEIO = NOVO_RATEIO + @VLR
		WHERE
			CD_FILIAL =@CD_FILIAL
			AND CD_NF =@CD_NF
			AND CD_PROD = @CD_PROD
			AND SEQ = @SEQ
			AND (NOVO_RATEIO + @VLR) >= 0;
			
		IF @@ROWCOUNT > 0 
		BEGIN
			UPDATE #TMP_RATEIO
			SET	
				DIFER = DIFER - @VLR
			WHERE
				CD_FILIAL =@CD_FILIAL
				AND CD_NF =@CD_NF 
		END 
			
		FETCH NEXT FROM crateio INTO @CD_FILIAL , @CD_NF , @CD_PROD, @SEQ
		
	end
	
	CLOSE crateio
	DEALLOCATE crateio

	IF @CONSULTA =0 
	BEGIN
	
		UPDATE b
		set
			VLR_OUTRAS_DESPESAS = a.NOVO_RATEIO
		FROM 
			#TMP_RATEIO A
			INNER JOIN EST_NF_ENT_IT B ON 
			A.CD_PROD = B.CD_PROD AND
			A.CD_NF		= B.CD_NF AND
			A.CD_FILIAL = B.CD_FILIAL
		where
			b.VLR_OUTRAS_DESPESAS <> a.NOVO_RATEIO
	END
	ELSE
	BEGIN
		SELECT *  FROM #TMP_RATEIO
	END